/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman.router;

import filenet.vw.api.VWException;
import filenet.vw.apps.taskman.VWTaskActionCommand;
import filenet.vw.apps.taskman.VWTaskNumericProperty;
import filenet.vw.apps.taskman.VWTaskPropertyChangedEvent;
import filenet.vw.apps.taskman.VWTaskPropertyPanel;
import filenet.vw.apps.taskman.VWTaskTabPanel;
import filenet.vw.apps.taskman.VWTaskTabbedPane;
import filenet.vw.apps.taskman.router.VWRouterAdminNode;
import filenet.vw.apps.taskman.router.resources.VWResource;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.text.JTextComponent;

public class VWRouterAdminPropertyPanel
extends VWTaskPropertyPanel {
    VWRouterAdminNode m_routerAdminNode = null;
    VWTaskTabbedPane m_tabbedPane = null;
    VWTaskNumericProperty m_rmiPort = null;
    private static final boolean REQUIRED = true;
    private static final boolean NOT_REQUIRED = false;

    public VWRouterAdminPropertyPanel(VWRouterAdminNode routerAdminNode) {
        this.setDoubleBuffered(true);
        this.setLayout(new BorderLayout());
        this.m_routerAdminNode = routerAdminNode;
        this.addTabbedPane();
        this.refresh();
    }

    public void refresh() {
        this.resetProperties();
    }

    private void addTabbedPane() {
        this.m_tabbedPane = new VWTaskTabbedPane();
        this.m_tabbedPane.addTab(VWResource.General, this.getGeneralPanel());
        this.m_tabbedPane.addVWTaskPropertyChangedListener(this);
        this.add((Component)this.m_tabbedPane, "Center");
    }

    private VWTaskTabPanel getGeneralPanel() {
        VWTaskTabPanel panel = new VWTaskTabPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 0;
        c.anchor = 23;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(4, 10, 0, 0);
        c.gridx = 0;
        c.gridy = 0;
        JLabel iconLabel = new JLabel(this.m_routerAdminNode.getIcon32(), 2);
        panel.add((Component)iconLabel, c);
        c.fill = 2;
        c.weightx = 1.0;
        c.gridy = 0;
        c.gridx = 1;
        c.insets = new Insets(15, 10, 0, 0);
        c.gridwidth = 0;
        panel.add((Component)new JLabel(VWResource.ProcessRouters), c);
        c.gridy = 1;
        c.gridx = 0;
        c.fill = 1;
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(0, 5, 0, 0);
        panel.add((Component)this.getGeneralPropertiesPanel(), c);
        return panel;
    }

    private VWTaskTabPanel getGeneralPropertiesPanel() {
        VWTaskTabPanel panel = new VWTaskTabPanel();
        panel.setLayout(new GridBagLayout());
        panel.addVWTaskPropertyChangedListener(this);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.fill = 2;
        c.gridwidth = 1;
        c.insets = new Insets(10, 10, 0, 5);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridx = 0;
        ++c.gridy;
        this.m_rmiPort = new VWTaskNumericProperty("");
        this.m_rmiPort.setName(VWResource.AdministerRoutersOnPort);
        this.m_rmiPort.setPreferredSize(new Dimension(60, (int)this.m_rmiPort.getPreferredSize().getHeight()));
        panel.add((Component)new JLabel(this.m_rmiPort.getName()), c);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridx = 1;
        panel.add((JTextComponent)this.m_rmiPort, (Object)c, true);
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.gridx = 2;
        panel.add(Box.createHorizontalStrut(0), c);
        return panel;
    }

    public void actionPerformed(ActionEvent event) {
        String actionCMD = event.getActionCommand();
        Object aObj = event.getSource();
        boolean forwardEvent = true;
        try {
            if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.APPLY) == 0 || VWStringUtils.compare(actionCMD, VWTaskActionCommand.OK) == 0) {
                forwardEvent = this.validateProperties();
                if (forwardEvent) {
                    this.applyProperties();
                }
            } else if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.RESET) == 0 || VWStringUtils.compare(actionCMD, VWTaskActionCommand.CANCEL) == 0) {
                this.resetProperties();
            } else if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.HELP) == 0) {
                this.m_routerAdminNode.displayHelp();
            }
        }
        catch (Exception ex) {
            this.m_routerAdminNode.displayError(ex);
        }
    }

    public void applyProperties() {
        this.m_routerAdminNode.setRegistryPort(new Integer(this.m_rmiPort.getText().trim()));
        this.taskPropertyChanged(new VWTaskPropertyChangedEvent((Object)this, 1));
    }

    public void resetProperties() {
        this.m_rmiPort.setText(this.m_routerAdminNode.getRegistryPort().toString());
        this.taskPropertyChanged(new VWTaskPropertyChangedEvent((Object)this, 2));
    }

    private boolean validateProperties() {
        try {
            this.m_tabbedPane.validateProperties();
        }
        catch (VWException e) {
            this.m_routerAdminNode.displayError(e);
            return false;
        }
        return true;
    }
}

